#ifndef LG_SWI_H
#define LG_SWI_H


#define SWI(call)		__asm{swi call<<16 }

#define SWI_HALT	0x2
#define	SWI_VBLANK	0x5


//for CPUSet
#define MODE_32BIT
//for CPUSet & CPUFastSet
#define FIXED_SOURCE (1<<24)



u16 Sqrt(u32 number);
u16 ArcTan(u32 number);
u16 ArcTan2(u32 x, u32 y);

void CPUSet(void *source, void *destination, u32 mode);
void CPUFastSet(void *source, void *destination, u32 mode);
void BitUnPack(void *source, void* destination, const void* header);
void LZ77UnCompWRAM (void *source, void *destination);
void LZ77UnCompVRAM (void *source, void *destination);


#endif

